<?php 

/**
 * Force Visual Composer to initialize as "built into the theme". This will hide certain tabs under the Settings->Visual Composer page
 */
if( function_exists('vc_set_as_theme') ){
	function ebor_vcSetAsTheme() {
		vc_set_as_theme(true);
	}
	add_action( 'vc_before_init', 'ebor_vcSetAsTheme' );
}

if(!( function_exists('ebor_custom_css_classes_for_vc_row_and_vc_column') )){
	function ebor_custom_css_classes_for_vc_row_and_vc_column( $class_string, $tag ) {
		if ( $tag == 'vc_column' || $tag == 'vc_column_inner' ) {
			$class_string = preg_replace( '/vc_col-sm-(\d{1,2})/', 'col-md-$1', $class_string );
		}
		return $class_string;
	}
	add_filter( 'vc_shortcodes_css_class', 'ebor_custom_css_classes_for_vc_row_and_vc_column', 10, 2 );
}

if(!( function_exists('ebor_icons_settings_field') )){
	function ebor_icons_settings_field( $settings, $value ) {
		
		$icons = $settings['value'];
		
		$output = '<a href="#" id="ebor-icon-toggle" class="button button-primary button-large">Show/Hide Icons</a><div class="ebor-icons"><div class="ebor-icons-wrapper">';
		foreach( $icons as $icon ){
			$active = ( $value == $icon) ? ' active' : '';
			$output .= '<i class="icon '. $icon . $active .'" data-icon-class="'. $icon .'"></i>';
		}
		$output .= '</div><input name="' . esc_attr( $settings['param_name'] ) . '" class="wpb_vc_param_value wpb-textinput ebor-icon-value ' .
		esc_attr( $settings['param_name'] ) . ' ' .
		esc_attr( $settings['type'] ) . '_field" type="text" value="' . esc_attr( $value ) . '" />' . '</div>';
		
	   return $output;
	}
	add_shortcode_param( 'ebor_icons', 'ebor_icons_settings_field' );
}

/**
 * Add additional functions to certain blocks.
 * vc_map runs before custom post types and taxonomies are created, so this function is used
 * to add custom taxonomy selectors to VC blocks, a little annoying, but works perfectly.
 */
if(!( function_exists('ebor_vc_add_att') )){
	function ebor_vc_add_attr(){
		
		$attributes = array(
			"type" => "textarea_html",
			"heading" => esc_html__("Block Content", 'do'),
			"param_name" => "content",
			'holder' => 'div'
		);
		add_shortcode_param('vc_gmaps', $attributes);
		
		vc_remove_param('vc_gmaps', 'title');
		vc_remove_param('vc_gmaps', 'size');
		vc_remove_param('vc_gmaps', 'el_class');
		
	}
	add_action('init', 'ebor_vc_add_attr', 999);
}

/**
 * Redirect page template if vc_row shortcode is found in the page.
 * This lets us use a dedicated page template for Visual Composer pages
 * without the need for on page checks, or custom page templates.
 * 
 * It's buyer-proof basically.
 */
if(!( function_exists('ebor_vc_page_template') )){
	function ebor_vc_page_template( $template ){
		global $post;
		
		if( is_archive() || is_404() )
			return $template;
		
		if(!( isset($post->post_content) ) || is_search() )
			return $template;
			
		if( has_shortcode($post->post_content, 'vc_row') ){
			$new_template = locate_template( array( 'page_visual_composer.php' ) );
			
			if( is_singular('portfolio') ){
				$new_template = locate_template( array( 'page_visual_composer_single_portfolio.php' ) );
			}
			
			if (!( '' == $new_template )){
				return $new_template;
			}
		}
		return $template;
	}
	add_filter( 'template_include', 'ebor_vc_page_template', 99 );
}



/**
 * Add Pages to VC Template system
 */
// Homepage 1
if(!( function_exists('ebor_do_homepage1_template') )){
function ebor_do_homepage1_template($data){
    $template               = array();
    $template['name']       = 'Homepage 1';
    $template['content']    = <<<CONTENT
        [vc_row full_width="stretch_row" css=".vc_custom_1444404041726{padding-top: 0px !important;padding-bottom: 0px !important;}"][vc_column][vc_column_text][rev_slider_vc alias="homepage1"][/vc_column_text][/vc_column][/vc_row][vc_row css=".vc_custom_1444135722712{padding-top: 0px !important;padding-bottom: 0px !important;background-color: #f5f5f5 !important;}"][vc_column][do_service_box icon="icon-trophy" title="Design"]
		<h3 style="text-align: center;">DESIGN</h3>
		<p style="text-align: center;">No one rejects, dislikes, or avoids pleasure itself, because it is pleasure, but because those who do not know how to pursue pleasure</p>
		[/do_service_box][do_service_box icon="icon-anchor" title="Products"]
		<h3 style="text-align: center;">PRODUCTS</h3>
		<p style="text-align: center;">No one rejects, dislikes, or avoids pleasure itself, because it is pleasure, but because those who do not know how to pursue pleasure</p>
		[/do_service_box][do_service_box icon="icon-shield" title="Awards"]
		<h3 style="text-align: center;">AWARDS</h3>
		<p style="text-align: center;">No one rejects, dislikes, or avoids pleasure itself, because it is pleasure, but because those who do not know how to pursue pleasure</p>
		[/do_service_box][do_service_box icon="icon-plane" title="Partners"]
		<h3 style="text-align: center;">PARTNERS</h3>
		<p style="text-align: center;">No one rejects, dislikes, or avoids pleasure itself, because it is pleasure, but because those who do not know how to pursue pleasure</p>
		[/do_service_box][/vc_column][/vc_row][vc_row css=".vc_custom_1444135937937{padding-bottom: 0px !important;}"][vc_column][do_section_title title="ABOUT US" subtitle="CREATIVE &amp; EXPERT"][vc_column_text]
		<p class="lead" style="text-align: center;">Dislikes, or avoids pleasure itself, because it is pleasure, but because those who do not know how to pursue pleasure rationally encounter consequences that are extremely painful. Nor again is there anyone who loves</p>
		<p style="text-align: center;"><a class="do-btn-round-outline" href="#">MORE</a></p>
		[/vc_column_text][vc_empty_space height="80px"][do_small_images slides="87,88,89,90,92"][/vc_column][/vc_row][vc_row css=".vc_custom_1448654696857{padding-top: 65px !important;padding-bottom: 50px !important;background-color: #f5f5f5 !important;}"][vc_column width="1/4" css=".vc_custom_1448654451679{padding-right: 20px !important;padding-left: 20px !important;}"][do_icon_box icon="icon-microphone"]
		<h3 style="text-align: center;"><a href="#">SOUNDS GOOD</a></h3>
		<p style="text-align: center;">On the other hand, we denounce with right ous indignation and dislike mens who are so beguiled.</p>
		[/do_icon_box][/vc_column][vc_column width="1/4" css=".vc_custom_1448654463533{padding-right: 20px !important;padding-left: 20px !important;}"][do_icon_box icon="icon-present" title="0.5s"]
		<h3 style="text-align: center;"><a href="#">BOX STYLE</a></h3>
		<p style="text-align: center;">On the other hand, we denounce with right ous indignation and dislike mens who are so beguiled.</p>
		[/do_icon_box][/vc_column][vc_column width="1/4" css=".vc_custom_1448654471069{padding-right: 20px !important;padding-left: 20px !important;}"][do_icon_box icon="icon-energy" title="0.7s"]
		<h3 style="text-align: center;"><a href="#">SHARING</a></h3>
		<p style="text-align: center;">On the other hand, we denounce with right ous indignation and dislike mens who are so beguiled.</p>
		[/do_icon_box][/vc_column][vc_column width="1/4" css=".vc_custom_1448654478573{padding-right: 20px !important;padding-left: 20px !important;}"][do_icon_box icon="icon-shuffle" title="0.9s"]
		<h3 style="text-align: center;"><a href="#">NICE LOOP</a></h3>
		<p style="text-align: center;">On the other hand, we denounce with right ous indignation and dislike mens who are so beguiled.</p>
		[/do_icon_box][/vc_column][/vc_row][vc_row parallax="content-moving" css=".vc_custom_1448655024101{padding-top: 120px !important;padding-bottom: 125px !important;background-image: url(http://do.jeweltheme.com/wp-content/uploads/2015/10/counter.jpg?id=100) !important;}"][vc_column width="1/4"][do_counter icon="pe-7s-graph3" title="Work" from="0" to="136800"][/vc_column][vc_column width="1/4"][do_counter icon="pe-7s-bicycle" title="Sale" from="0" to="276500"][/vc_column][vc_column width="1/4"][do_counter icon="pe-7s-coffee" title="Demo" from="0" to="148630"][/vc_column][vc_column width="1/4"][do_counter icon="pe-7s-graph1" title="Client" from="0" to="136800"][/vc_column][/vc_row][vc_row css=".vc_custom_1444139942839{background-color: #f5f5f5 !important;}"][vc_column width="1/3"][vc_column_text]
		<h3>FACTS WE HAVE</h3>
		counter buti because those who do not know how an puIse pleasure rationally encounter consequences that are painci No one rejects, dislikes, or avoids pleasure itself, because is counter buti because those who do not know how an puIse Nor again is there anyone who loves or pursues and desirn

		pleasure rationally encounter consequences that are painci counter buti because those who do not know how an puIse pleasure rationally encounter. Nor again is there anyone who loves or pursues and desirn[/vc_column_text][/vc_column][vc_column width="1/3"][vc_column_text]
		<h3>KEY FEATURES</h3>
		<ul class="do-icon-list">
			<li>Pleasures rationally encounter consequences</li>
			<li>Sample analysis and mobile networking system</li>
			<li>Business communication management</li>
			<li>Sample analysis and mobile networking system</li>
			<li>Technical writing with perfect translation</li>
			<li>Web data structural development ready</li>
			<li>Business communication management</li>
		</ul>
		[/vc_column_text][/vc_column][vc_column width="1/3"][vc_column_text]
		<h3>PROGRESS BAR</h3>
		[/vc_column_text][do_skill_bar_block title="Design" amount="69"][do_skill_bar_block title="Code" amount="80"][do_skill_bar_block title="Writing" amount="69"][do_skill_bar_block title="Photography" amount="40"][/vc_column][/vc_row][vc_row css=".vc_custom_1448705685355{margin-right: 30px !important;margin-left: 15px !important;}"][vc_column css=".vc_custom_1448706737483{margin-right: 15px !important;margin-left: 15px !important;padding-right: 35px !important;padding-left: 20px !important;}"][do_section_title title="WORK" subtitle="OUR CREATIVE GALLERY"][do_portfolio type="5col" filters="no"][vc_btn title="More" el_class="text-center" link="url:http%3A%2F%2Fdo.jeweltheme.com%2Fportfolio-2-column%2F||"][/vc_column][/vc_row][vc_row css=".vc_custom_1444209902135{padding-top: 120px !important;padding-bottom: 0px !important;background-image: url(http://do.jeweltheme.com/wp-content/uploads/2015/10/shadow-top.png?id=186) !important;}" el_id="team-section"][vc_column][do_section_title title="OUR TEAM" subtitle="AWESOME CREATIVE TEAM"][do_team pppage="5"][/vc_column][/vc_row][vc_row parallax="content-moving" css=".vc_custom_1444140408192{background-image: url(http://do.jeweltheme.com/wp-content/uploads/2015/10/testimonial.jpg?id=107) !important;}"][vc_column][do_page_alt_title title="CLIENT SAYS"][do_testimonial][/vc_column][/vc_row][vc_row css=".vc_custom_1444140216194{background-color: #f5f5f5 !important;}"][vc_column][do_section_title title="FROM BLOG" subtitle="BEST THEME FOR BUSINESS"][do_blog pppage="3" type="masonry-no-sidebar" pagination="no"][vc_btn title="More" el_class="text-center" link="url:http%3A%2F%2Fdo.jeweltheme.com%2Fblog%2Fblog-grid%2F||" css=".vc_custom_1448656339418{margin-top: 20px !important;}"][/vc_column][/vc_row][vc_row][vc_column width="1/2"][vc_single_image image="109" img_size="full" alignment="center"][/vc_column][vc_column width="1/2" el_class="do-custom-sec-content"][vc_column_text]
		<h3>EXTRA FEATURE</h3>
		No one rejects, dislikes, or avoids pleasure itself, because is counter because upon those who do not know how an puIse pleasure rationally encounter consequnce is Nor again is there anyone who loves
		<ul class="do-icon-list">
			<li>Fresh clean theme for business or personal</li>
			<li>Made with love and care for you</li>
			<li>Pixel perfect coding done</li>
		</ul>
		<a class="do-btn-round-solid" href="#">MORE</a>[/vc_column_text][/vc_column][/vc_row][vc_row video_bg="yes"][vc_column][vc_column_text]
		<h3 style="text-align: center;">GET THE TEMPLATE</h3>
		<p style="text-align: center;">On the other hand, we denounce with right ous indignation and dislike mens beguiled</p>
		<p style="text-align: center;"><a class="do-btn-round-outline" href="#">PURCHASE</a></p>
		[/vc_column_text][/vc_column][/vc_row]
CONTENT;
    array_unshift($data, $template);
    return $data;
}

add_filter( 'vc_load_default_templates', 'ebor_do_homepage1_template' );
}




// Homepage 2
if(!( function_exists('ebor_do_homepage2_template') )){
function ebor_do_homepage2_template($data){
    $template               = array();
    $template['name']       = 'Homepage 2';
    $template['content']    = <<<CONTENT
        [vc_row full_width="stretch_row" css=".vc_custom_1444404041726{padding-top: 0px !important;padding-bottom: 0px !important;}"][vc_column][vc_column_text][rev_slider_vc alias="homepage-2"][/vc_column_text][/vc_column][/vc_row][vc_row css=".vc_custom_1444136474925{background-color: #f5f5f5 !important;}"][vc_column width="1/4"][do_icon_box icon="icon-microphone" type="do-icon-with-text-style3"]
		<h3 style="text-align: center;"><a href="#">SOUNDS GOOD</a></h3>
		<p style="text-align: center;">On the other hand, we denounce with right ous indignation and dislike mens who are so beguiled.</p>
		[/do_icon_box][/vc_column][vc_column width="1/4"][do_icon_box icon="icon-present" title="0.5s" type="do-icon-with-text-style3"]
		<h3 style="text-align: center;"><a href="#">BOX STYLE</a></h3>
		<p style="text-align: center;">On the other hand, we denounce with right ous indignation and dislike mens who are so beguiled.</p>
		[/do_icon_box][/vc_column][vc_column width="1/4"][do_icon_box icon="icon-energy" title="0.7s" type="do-icon-with-text-style3"]
		<h3 style="text-align: center;"><a href="#">SHARING</a></h3>
		<p style="text-align: center;">On the other hand, we denounce with right ous indignation and dislike mens who are so beguiled.</p>
		[/do_icon_box][/vc_column][vc_column width="1/4"][do_icon_box icon="icon-shuffle" title="0.9s" type="do-icon-with-text-style3"]
		<h3 style="text-align: center;"><a href="#">NICE LOOP</a></h3>
		<p style="text-align: center;">On the other hand, we denounce with right ous indignation and dislike mens who are so beguiled.</p>
		[/do_icon_box][/vc_column][/vc_row][vc_row][vc_column width="1/2"][vc_single_image image="109" img_size="full" alignment="center"][/vc_column][vc_column width="1/2" el_class="do-custom-sec-content"][vc_column_text]
		<h3>EXTRA FEATURE</h3>
		No one rejects, dislikes, or avoids pleasure itself, because is counter because upon those who do not know how an puIse pleasure rationally encounter consequnce is Nor again is there anyone who loves
		<ul class="do-icon-list">
			<li>Fresh clean theme for business or personal</li>
			<li>Made with love and care for you</li>
			<li>Pixel perfect coding done</li>
		</ul>
		<a class="do-btn-round-solid" href="#">MORE</a>[/vc_column_text][/vc_column][/vc_row][vc_row css=".vc_custom_1448719637892{padding-top: 0px !important;padding-bottom: 0px !important;background-color: #31c2b1 !important;}"][vc_column width="1/4"][do_counter icon="pe-7s-graph3" type="white" title="Work" from="0" to="136800"][/vc_column][vc_column width="1/4"][do_counter icon="pe-7s-bicycle" type="white" title="Sale" from="0" to="276500"][/vc_column][vc_column width="1/4"][do_counter icon="pe-7s-coffee" type="white" title="Demo" from="0" to="148630"][/vc_column][vc_column width="1/4"][do_counter icon="pe-7s-umbrella" type="white" title="Client" from="0" to="136800"][/vc_column][/vc_row][vc_row parallax="content-moving" parallax_image="230" css=".vc_custom_1444217833590{padding-top: 140px !important;padding-bottom: 140px !important;}"][vc_column][vc_column_text]
		<h3 style="text-align: center;">GET THE TEMPLATE</h3>
		<p style="text-align: center;">On the other hand, we denounce with right ous indignation and dislike mens beguiled</p>
		<p style="text-align: center;"><a class="do-btn-round-outline" href="#">PURCHASE</a></p>
		[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column][do_section_title title="WORK" subtitle="OUR CREATIVE GALLERY"][do_portfolio type="5col" filters="no"][vc_btn title="More" link="url:http%3A%2F%2Fdo.jeweltheme.com%2Fportfolio-2-column%2F||" el_class="text-center"][/vc_column][/vc_row][vc_row css=".vc_custom_1444140216194{background-color: #f5f5f5 !important;}"][vc_column][do_section_title title="FROM BLOG" subtitle="BEST THEME FOR BUSINESS"][do_blog pppage="4" pagination="no"][vc_btn title="More" link="url:http%3A%2F%2Fdo.jeweltheme.com%2Fblog%2Fblog-strip%2F||" el_class="text-center" css=".vc_custom_1448720435799{margin-top: 70px !important;}"][/vc_column][/vc_row][vc_row css=".vc_custom_1448720227250{padding-top: 70px !important;padding-bottom: 15px !important;}"][vc_column][do_client pppage="6"][/vc_column][/vc_row][vc_row full_width="stretch_row"][vc_column][vc_gmaps link="#E-8_JTNDaWZyYW1lJTIwc3JjJTNEJTIyaHR0cHMlM0ElMkYlMkZ3d3cuZ29vZ2xlLmNvbSUyRm1hcHMlMkZlbWJlZCUzRnBiJTNEJTIxMW0xOCUyMTFtMTIlMjExbTMlMjExZDYzMDQuODI5OTg2MTMxMjcxJTIxMmQtMTIyLjQ3NDY5NjgwMzMwOTIlMjEzZDM3LjgwMzc0NzUyMTYwNDQzJTIxMm0zJTIxMWYwJTIxMmYwJTIxM2YwJTIxM20yJTIxMWkxMDI0JTIxMmk3NjglMjE0ZjEzLjElMjEzbTMlMjExbTIlMjExczB4ODA4NTg2ZTYzMDI2MTVhMSUyNTNBMHg4NmJkMTMwMjUxNzU3YzAwJTIxMnNTdG9yZXklMkJBdmUlMjUyQyUyQlNhbiUyQkZyYW5jaXNjbyUyNTJDJTJCQ0ElMkI5NDEyOSUyMTVlMCUyMTNtMiUyMTFzZW4lMjEyc3VzJTIxNHYxNDM1ODI2NDMyMDUxJTIyJTIwd2lkdGglM0QlMjI2MDAlMjIlMjBoZWlnaHQlM0QlMjI1NTAlMjIlMjBmcmFtZWJvcmRlciUzRCUyMjAlMjIlMjBzdHlsZSUzRCUyMmJvcmRlciUzQTAlMjIlMjBhbGxvd2Z1bGxzY3JlZW4lM0UlM0MlMkZpZnJhbWUlM0U="]
		<h3>Send A Message</h3>
		[contact-form-7 id="236" title="Do Map Contact Form"][/vc_gmaps][/vc_column][/vc_row]
CONTENT;
    array_unshift($data, $template);
    return $data;
}

add_filter( 'vc_load_default_templates', 'ebor_do_homepage2_template' );
}





// Homepage 3
if(!( function_exists('ebor_do_homepage3_template') )){
function ebor_do_homepage3_template($data){
    $template               = array();
    $template['name']       = 'Homepage 3';
    $template['content']    = <<<CONTENT
        [vc_row full_width="stretch_row" css=".vc_custom_1444404041726{padding-top: 0px !important;padding-bottom: 0px !important;}"][vc_column][rev_slider_vc alias="homepage-3"][/vc_column][/vc_row][vc_row][vc_column width="1/4"][do_icon_box icon="icon-microphone"]
		<h3 style="text-align: center;"><a href="#">SOUNDS GOOD</a></h3>
		<p style="text-align: center;">On the other hand, we denounce with right ous indignation and dislike mens who are so beguiled.</p>
		[/do_icon_box][/vc_column][vc_column width="1/4"][do_icon_box icon="icon-present" title="0.5s"]
		<h3 style="text-align: center;"><a href="#">BOX STYLE</a></h3>
		<p style="text-align: center;">On the other hand, we denounce with right ous indignation and dislike mens who are so beguiled.</p>
		[/do_icon_box][/vc_column][vc_column width="1/4"][do_icon_box icon="icon-energy" title="0.7s"]
		<h3 style="text-align: center;"><a href="#">SHARING</a></h3>
		<p style="text-align: center;">On the other hand, we denounce with right ous indignation and dislike mens who are so beguiled.</p>
		[/do_icon_box][/vc_column][vc_column width="1/4"][do_icon_box icon="icon-shuffle" title="0.9s"]
		<h3 style="text-align: center;"><a href="#">NICE LOOP</a></h3>
		<p style="text-align: center;">On the other hand, we denounce with right ous indignation and dislike mens who are so beguiled.</p>
		[/do_icon_box][/vc_column][/vc_row][vc_row css=".vc_custom_1444224504197{background-color: #f5f5f5 !important;}"][vc_column width="1/2"][vc_single_image image="247" img_size="full" alignment="center"][/vc_column][vc_column width="1/2" el_class="do-custom-sec-content"][vc_column_text]
		<h3>EXTRA FEATURE</h3>
		No one rejects, dislikes, or avoids pleasure itself, because is counter because upon those who do not know how an puIse pleasure rationally encounter consequnce is Nor again is there anyone who loves
		<ul class="do-icon-list">
			<li>Fresh clean theme for business or personal</li>
			<li>Made with love and care for you</li>
			<li>Pixel perfect coding done</li>
		</ul>
		<a class="do-btn-round-solid" href="#">MORE</a>[/vc_column_text][/vc_column][/vc_row][vc_row css=".vc_custom_1448661519508{padding-top: 35px !important;padding-bottom: 45px !important;background-color: #19bd9b !important;}" el_class="do-cta-one"][vc_column width="1/12"][/vc_column][vc_column width="8/12"][vc_column_text]
		<h2 class="white">LETS TALK ABOUT PREMIUM WEBSITE. ARE YOU READY ?</h2>
		[/vc_column_text][/vc_column][vc_column width="2/12"][vc_column_text]<a class="do-btn-round-outline white" href="#">REGISTAR</a>[/vc_column_text][/vc_column][vc_column width="1/12"][/vc_column][/vc_row][vc_row full_width="stretch_row"][vc_column][do_portfolio type="slider" filters="no"][/vc_column][/vc_row][vc_row][vc_column width="1/3"][vc_column_text]
		<h3>FACTS WE HAVE</h3>
		counter buti because those who do not know how an puIse pleasure rationally encounter consequences that are painci No one rejects, dislikes, or avoids pleasure itself, because is counter buti because those who do not know how an puIse Nor again is there anyone who loves or pursues and desirn

		pleasure rationally encounter consequences that are painci counter buti because those who do not know how an puIse pleasure rationally encounter. Nor again is there anyone who loves or pursues and desirn[/vc_column_text][/vc_column][vc_column width="1/3"][vc_column_text]
		<h3>KEY FEATURES</h3>
		<ul class="do-icon-list">
			<li>Pleasures rationally encounter consequences</li>
			<li>Sample analysis and mobile networking system</li>
			<li>Business communication management</li>
			<li>Sample analysis and mobile networking system</li>
			<li>Technical writing with perfect translation</li>
			<li>Web data structural development ready</li>
			<li>Business communication management</li>
		</ul>
		[/vc_column_text][/vc_column][vc_column width="1/3"][vc_column_text]
		<h3>PROGRESS BAR</h3>
		[/vc_column_text][do_skill_bar_block title="Design" amount="69"][do_skill_bar_block title="Code" amount="80"][do_skill_bar_block title="Writing" amount="69"][do_skill_bar_block title="Photography" amount="40"][/vc_column][/vc_row][vc_row parallax="content-moving" parallax_image="446" el_class="do-features-with-img-wrapper"][vc_column][do_section_title title="MAIN FEATURES" subtitle="BEST THEME FOR BUSINESS"][vc_row_inner][vc_column_inner width="1/3"][do_right_icon_box feature_right_box_icon="ti-mobile" feature_right_box_content="

		On the other hand, we denounce with right ous indignation and dislike mens who are so beguiled

		"][do_right_icon_box feature_right_box_icon="pe-7s-rocket" feature_right_box_title="MANY FEATURES" feature_right_box_content="

		On the other hand, we denounce with right ous indignation and dislike mens who are so beguiled

		"][do_right_icon_box feature_right_box_icon="pe-7s-way" feature_right_box_title="FORUM READY" feature_right_box_content="

		On the other hand, we denounce with right ous indignation and dislike mens who are so beguiled

		"][/vc_column_inner][vc_column_inner width="1/3"][vc_single_image image="481" img_size="full" el_class="fadeInUp"][/vc_column_inner][vc_column_inner width="1/3"][do_left_icon_box feature_left_box_icon="pe-7s-like" feature_left_box_title="USER FRIENDLY" feature_left_box_content="

		On the other hand, we denounce with right ous indignation and dislike mens who are so beguiled

		"][do_left_icon_box feature_left_box_icon="pe-7s-gleam" feature_left_box_title="SUPER CODE" feature_left_box_content="

		On the other hand, we denounce with right ous indignation and dislike mens who are so beguiled

		"][do_left_icon_box feature_left_box_icon="pe-7s-vector" feature_left_box_title="FLEXIBLE" feature_left_box_content="

		On the other hand, we denounce with right ous indignation and dislike mens who are so beguiled

		"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row css=".vc_custom_1444140216194{background-color: #f5f5f5 !important;}"][vc_column][do_section_title title="FROM BLOG" subtitle="BEST THEME FOR BUSINESS"][do_blog pppage="3" type="masonry-no-sidebar" pagination="no"][vc_btn title="More" link="url:http%3A%2F%2Fdo.jeweltheme.com%2Fblog%2Fblog-grid%2F||" el_class="text-center" css=".vc_custom_1448720817043{margin-top: 40px !important;}"][/vc_column][/vc_row][vc_row parallax="content-moving" parallax_image="525" css=".vc_custom_1448721363142{padding-top: 125px !important;padding-bottom: 125px !important;background-image: url(http://do.jeweltheme.com/wp-content/uploads/2015/10/counter.jpg?id=100) !important;}"][vc_column width="1/4"][do_counter icon="pe-7s-graph3" title="Work" from="0" to="136800"][/vc_column][vc_column width="1/4"][do_counter icon="pe-7s-bicycle" title="Sale" from="0" to="276500"][/vc_column][vc_column width="1/4"][do_counter icon="pe-7s-coffee" title="Demo" from="0" to="148630"][/vc_column][vc_column width="1/4"][do_counter icon="pe-7s-graph1" title="Client" from="0" to="136800"][/vc_column][/vc_row][vc_row css=".vc_custom_1448660717430{padding-top: 120px !important;padding-bottom: 0px !important;background-color: #f9f9f9 !important;}" el_id="team-section"][vc_column][do_section_title title="OUR TEAM" subtitle="AWESOME CREATIVE TEAM"][do_team_second][/vc_column][/vc_row][vc_row full_width="stretch_row"][vc_column][do_extra_feature left_image="474" right_image="475" class="``do-btn-round-outline``"][/vc_column][/vc_row][vc_row css=".vc_custom_1444225357540{padding-bottom: 0px !important;}"][vc_column width="1/2" el_class="do-custom-sec-content"][vc_column_text]
		<h3>Have Some More?</h3>
		No one rejects, dislikes, or avoids pleasure itself, because is counter because upon those who do not know how an puIse pleasure rationally encounter consequnce is Nor again is there anyone who loves
		<ul class="do-icon-list">
			<li>Fresh clean theme for business or personal</li>
			<li>Made with love and care for you</li>
			<li>Pixel perfect coding done</li>
		</ul>
		<a class="do-btn-round-solid" href="#">MORE</a>[/vc_column_text][/vc_column][vc_column width="1/2"][vc_single_image image="41" img_size="full" alignment="center"][/vc_column][/vc_row][vc_row css=".vc_custom_1448660242982{background: #ffffff url(http://do.jeweltheme.com/wp-content/uploads/2015/10/testimonial-sec-img.jpg?id=251) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" el_class="do-testimonial"][vc_column][do_page_alt_title title="CLIENT SAYS"][do_testimonial][/vc_column][/vc_row]
CONTENT;
    array_unshift($data, $template);
    return $data;
}

add_filter( 'vc_load_default_templates', 'ebor_do_homepage3_template' );
}





// Homepage 4
if(!( function_exists('ebor_do_homepage4_template') )){
function ebor_do_homepage4_template($data){
    $template               = array();
    $template['name']       = 'Homepage 4';
    $template['content']    = <<<CONTENT
        [vc_row full_width="stretch_row" css=".vc_custom_1444404041726{padding-top: 0px !important;padding-bottom: 0px !important;}"][vc_column][rev_slider_vc alias="homepage1"][/vc_column][/vc_row][vc_row][vc_column width="1/4"][do_icon_box icon="icon-microphone" type="do-icon-with-text-style3"]
		<h3 style="text-align: center;"><a href="#">SOUNDS GOOD</a></h3>
		<p style="text-align: center;">On the other hand, we denounce with right ous indignation and dislike mens who are so beguiled.</p>
		[/do_icon_box][/vc_column][vc_column width="1/4"][do_icon_box icon="icon-present" title="0.5s" type="do-icon-with-text-style3"]
		<h3 style="text-align: center;"><a href="#">BOX STYLE</a></h3>
		<p style="text-align: center;">On the other hand, we denounce with right ous indignation and dislike mens who are so beguiled.</p>
		[/do_icon_box][/vc_column][vc_column width="1/4"][do_icon_box icon="icon-energy" title="0.7s" type="do-icon-with-text-style3"]
		<h3 style="text-align: center;"><a href="#">SHARING</a></h3>
		<p style="text-align: center;">On the other hand, we denounce with right ous indignation and dislike mens who are so beguiled.</p>
		[/do_icon_box][/vc_column][vc_column width="1/4"][do_icon_box icon="icon-shuffle" title="0.9s" type="do-icon-with-text-style3"]
		<h3 style="text-align: center;"><a href="#">NICE LOOP</a></h3>
		<p style="text-align: center;">On the other hand, we denounce with right ous indignation and dislike mens who are so beguiled.</p>
		[/do_icon_box][/vc_column][/vc_row][vc_row css=".vc_custom_1444225778678{padding-bottom: 0px !important;background-color: #f9f9f9 !important;}"][vc_column width="1/2"][vc_single_image image="260" img_size="full" alignment="center" el_class="negative-top"][/vc_column][vc_column width="1/2"][vc_column_text]
		<h3>WE ARE AWESOME</h3>
		<p class="do-custom-highlighted">No one rejects, dislikes, or avoids pleasure itself, because counters upon on me those who do not know how an puIse pleasure ratonally encounter and nothing. No one rejects, dislikes, or avoids pleasure</p>
		those who do not know how an puIse pleasure rationally encounter consequnce is great min No one rejects, dislikes, or avoids pleasure itself, because is counter because upon based on those who do not know how an puIse pleasure rationally encounter consequnce is great min those who do not know how an puIse pleasure
		<h3><a class="do-btn-round-solid" href="#">MORE</a></h3>
		[/vc_column_text][/vc_column][/vc_row][vc_row css=".vc_custom_1448721788811{padding-top: 0px !important;padding-bottom: 0px !important;}"][vc_column width="1/4"][do_counter icon="pe-7s-graph3" type="black" title="Work" from="0" to="136800"][/vc_column][vc_column width="1/4"][do_counter icon="pe-7s-bicycle" type="black" title="Sale" from="0" to="276500"][/vc_column][vc_column width="1/4"][do_counter icon="pe-7s-coffee" type="black" title="Demo" from="0" to="148630"][/vc_column][vc_column width="1/4"][do_counter icon="pe-7s-graph1" type="black" title="Client" from="0" to="136800"][/vc_column][/vc_row][vc_row parallax="content-moving" parallax_image="230" css=".vc_custom_1444217833590{padding-top: 140px !important;padding-bottom: 140px !important;}"][vc_column][vc_column_text]
		<h3 style="text-align: center;">GET THE TEMPLATE</h3>
		<p style="text-align: center;">On the other hand, we denounce with right ous indignation and dislike mens beguiled</p>
		<p style="text-align: center;"><a class="do-btn-round-outline" href="#">PURCHASE</a></p>
		[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column][do_section_title title="WORK" subtitle="OUR CREATIVE GALLERY"][do_portfolio pppage="10" type="5col" filters="no"][vc_btn title="More" link="url:http%3A%2F%2Fdo.jeweltheme.com%2Fportfolio-4-column%2F||" el_class="text-center"][/vc_column][/vc_row][vc_row css=".vc_custom_1444140216194{background-color: #f5f5f5 !important;}"][vc_column][do_section_title title="FROM BLOG" subtitle="BEST THEME FOR BUSINESS"][do_blog pppage="4" pagination="no"][vc_btn title="More" link="url:http%3A%2F%2Fdo.jeweltheme.com%2Fblog%2Fblog-strip%2F||" el_class="text-center" css=".vc_custom_1448721968245{margin-top: 70px !important;}"][/vc_column][/vc_row][vc_row parallax="content-moving" parallax_image="545" css=".vc_custom_1448724683602{background: #f5f5f5 url(http://do.jeweltheme.com/wp-content/uploads/2015/10/testimonial-sec-img-white1.jpg?id=545);}" el_class="blank-bg"][vc_column][do_page_alt_title title="Testimonials" subtitle="Inspiration from our clients"][do_testimonial][/vc_column][/vc_row][vc_row parallax="content-moving" parallax_image="537" el_class="Client"][vc_column][do_section_title title="OUR CLIENTS" subtitle="OUR VALUABLE CLIENT"][do_client pppage="6"][/vc_column][/vc_row]
CONTENT;
    array_unshift($data, $template);
    return $data;
}

add_filter( 'vc_load_default_templates', 'ebor_do_homepage4_template' );
}