jQuery(document).ready(function(){
	"use strict";
	
	//WordPress Stuff
	jQuery('.do-blog-sidebar li a, .do-icon-list li').prepend('<i class="fa fa-angle-right"></i>');
	jQuery('.vc_row').not('.vc_row[data-vc-full-width]').wrapInner('<div class="inner clearfix" />');


/* ------------------------------------------------------------------
                PRELOADER                     
                ------------------------------------------------------------------ */
                jQuery(window).load(function() {
                	jQuery(".status").fadeOut();
                	jQuery(".preloader").delay(1000).fadeOut("slow");
                });


/* ------------------------------------------------------------------
                FOR SCROLL UP BUTTON                     
                ------------------------------------------------------------------ */
                jQuery.scrollUp({
		scrollName: 'scrollUp', // Element ID
		scrollDistance: 300, // Distance from top/bottom before showing element (px)
		scrollFrom: 'top', // 'top' or 'bottom'
		scrollSpeed: 300, // Speed back to top (ms)
		easingType: 'linear', // Scroll to top easing (see http://easings.net/)
		animation: 'fade', // Fade, slide, none
		animationInSpeed: 200, // Animation in speed (ms)
		animationOutSpeed: 200, // Animation out speed (ms)
		scrollText: 'Scroll to top', // Text for element, can contain HTML
		scrollTitle: false, // Set a custom <a> title if required. Defaults to scrollText
		scrollImg: true, // Set true to use image
		activeOverlay: false, // Set CSS color to display scrollUp active point, e.g '#00FFFF'
		zIndex: 2147483647 // Z-Index for the overlay
	});

/* ==================================================================
				Change the menu height on scroll
				================================================================== */
				jQuery(window).on('scroll', function() {
					if (jQuery(window).scrollTop() > 1) {
						jQuery('.do-main-menu').addClass('minified');
					} else {
						jQuery('.do-main-menu').removeClass('minified');
					}
				});

/* ------------------------------------------------------------------
                USED FOR CLICK TO HIDE MENU                     
                ------------------------------------------------------------------ */
                jQuery(".nav a").on("click", function () {
                	jQuery("#nav-menu").removeClass("in").addClass("collapse")
                });

                jQuery(".navbar-collapse").css({ maxHeight: jQuery(window).height() - jQuery(".navbar-header").height() + "px" });

/* ------------------------------------------------------------------
SMOOTH SCROll
------------------------------------------------------------------ */
	smoothScroll.init({
	    speed: 1500, // Integer. How fast to complete the scroll in milliseconds
	    easing: 'easeInOutCubic', // Easing pattern to use
	    updateURL: true, // Boolean. Whether or not to update the URL with the anchor hash on scroll
	    offset: 0, // Integer. How far to offset the scrolling anchor location in pixels
	    callback: function ( toggle, anchor ) {} // Function to run after scrolling
	});



/* ------------------------------------------------------------------
IPhone Double Tap Service Section
------------------------------------------------------------------ */
jQuery('.do-service-container').each(function() {
    var $parentContainer = jQuery(this),
          $frontPart = $parentContainer.find('.do-front-part'),
          $backPart = $parentContainer.find('.do-back-part');

    var tapped=false;

     $frontPart.on('click touchend', function(e) {
        var el = $(this);

        if(!tapped){ 
          tapped=setTimeout(function(){
              tapped=null;
          },300); 
        } else {
          clearTimeout(tapped);
          tapped=null;

          el.css({
            opacity: 0,
            transform: 'translateY(-110px) rotateX(90deg)'
        });
        $backPart.css({
            opacity: 1,
            transform: ' rotateX(0)'
        });
        }
        //e.preventDefault();
    });

    $backPart.on('click touchend', function(e) {
       // e.preventDefault();

        var el = $(this);
        el.css({
            opacity: 0,
            transform: 'translateY(110px) rotateX(-90deg)'
        });
        $frontPart.css({
            opacity: 1,
            transform: ' rotateX(0)'
        });
    });
});



/* ------------------------------------------------------------------
                			Lightbox
                			------------------------------------------------------------------ */
                			jQuery('.do-work-item-popup').magnificPopup({
                				type: 'image',
                				gallery:{
                					enabled:true
                				}
                			});


                			jQuery(window).stellar({
                				responsive: true,
                				horizontalScrolling: false,
                				hideDistantElements: false,
                				verticalOffset: 0,
                				horizontalOffset: 0,
                			});

/* ---------------------------------------------
	Blog and Team Slider
	--------------------------------------------- */
	jQuery("#do-team-carousal").owlCarousel({
		items : 4,
		itemsDesktop : [1199,4],
		itemsDesktopSmall : [980,3],
		itemsTablet: [768,3],
		itemsTabletSmall: [767,2],
		itemsMobile : [479,1],
		autoPlay: 6000,
		navigation : false,
		pagination : true
	});

	jQuery("#do-blog-slider").owlCarousel({    
		singleItem : true,
		autoPlay: 10000,
		navigation : false,
		pagination : true
	});

	jQuery("#do-testimonial-1st").owlCarousel({
		items : 1,
		itemsDesktop: [1199,1],
		itemsDesktopSmall: [979,1],
		itemsTablet: [768,1],
		itemsMobile : [520,1],
		autoPlay: false,
		navigation : false,
		pagination: true
	});

	jQuery("#do-testimonial-2nd").owlCarousel({
	//Items
	items : 1,
	itemsDesktop: [1199,1],
	itemsDesktopSmall: [979,1],
	itemsTablet: [768,1],
	itemsMobile : [520,1],

	//Autoplay
	autoPlay: 6000,

	// Navigation
	navigation : true,
	navigationText: ["",""],

	//Pagination
	pagination: false
});


	jQuery("#do-related-work-carousal").owlCarousel({
	//Items
	items : 4,
	itemsDesktop: [1199,4],
	itemsDesktopSmall: [979,3],
	itemsTablet: [768,2],
	itemsMobile : [520,1],

	//Autoplay
	autoPlay: 7000,

	// Navigation
	navigation : false,
	navigationText: ["",""],

	//Pagination
	pagination: false
});


	jQuery("#do-portfolio-slider").owlCarousel({
	//Items
	items : 5,
	itemsDesktop: [1199,5],
	itemsDesktopSmall: [979,4],
	itemsTablet: [768,3],
	itemsMobile : [520,1],

	//Autoplay
	autoPlay: 7000,

	// Navigation
	navigation : false,
	navigationText: ["",""],

	//Pagination
	pagination: false
});

	jQuery("#do-logo-slider").owlCarousel({
	//Items
	items : 4,
	itemsDesktop: [1199,4],
	itemsDesktopSmall: [979,3],
	itemsTablet: [768,3],
	itemsMobile : [520,1],

	//Autoplay
	autoPlay: false,

	// Navigation
	navigation : false,

	//Pagination
	pagination: true
});

	jQuery("#do-logo-slider-2nd").owlCarousel({
	//Items
	items : 5,
	itemsDesktop: [1199,5],
	itemsDesktopSmall: [979,5],
	itemsTablet: [768,3],
	itemsMobile : [520,1],

	//Autoplay
	autoPlay: false,

	// Navigation
	navigation : false,

	//Pagination
	pagination: true
});

/* ==================================================================
					WoW Js
					================================================================== */
					var wow = new WOW({
	    boxClass:     'appear',      // animated element css class (default is wow)
	    animateClass: 'animated', // animation css class (default is animated)
	    offset:       100,          // distance to the element when triggering the animation (default is 0)
	    mobile:       true,       // trigger animations on mobile devices (default is true)
	    live:         true,       // act on asynchronously loaded content (default is true)
	    callback:     function(box) {
	      // the callback is fired every time an animation is started
	      // the argument that is passed in is the DOM node being animated
	  }
	});
					wow.init();



/* ==================================================================
                		SKILLBAR
                		================================================================== */
                		jQuery('.do-skillbar').waypoint(function(direction) {
                			jQuery('.do-skillbar[data-percent]').each(function () {
                				var skillbarWrapper = jQuery(this);
                				var progress = jQuery(this).find('span.skill-bar-percent');
                				var percentage = Math.ceil(jQuery(this).attr('data-percent'));
                				jQuery({countNum: 0}).animate({countNum: percentage}, {
                					duration: 4000,
                					step: function() {
	        // What todo on every count
	        var pct = '';
	        if(percentage == 0){
	        	pct = Math.floor(this.countNum) + '%';
	        }else{
	        	pct = Math.floor(this.countNum+1) + '%';
	        }
	        progress.text(pct) && skillbarWrapper.find('.do-skillbar-bar').css('width',pct);
	    }
	});
                			});
                			this.destroy()
                		}, {
                			offset: '50%'
                		});

/* ==================================================================
                		COUNTER PLUGIN
                		================================================================== */
                		jQuery('.do-counter-section').waypoint(function(direction) {
                			jQuery('.do-counter').countTo({
                				speed: 3500
                			});
                			this.destroy()
                		}, {
                			offset: 'bottom-in-view'
                		});

// HOMEPAGE 3
jQuery('.do-counter-section-2').waypoint(function(direction) {
	jQuery('.do-counter').countTo({
		speed: 3500
	});
	this.destroy()
}, {
	offset: 'bottom-in-view'
});


jQuery(function(){
	jQuery(window).on("resize.showContent", function() {
		var windowsize = jQuery(window).width();
		if(windowsize <= 767) {
    	// HOMEPAGE
    	jQuery('.do-counter-section').waypoint(function(direction) {
    		jQuery('.do-counter').countTo({
    			speed: 3500
    		});
    		this.destroy()
    	}, {
    		offset: '25%'
    	});


		// HOMEPAGE 3
		jQuery('.do-counter-section-2').waypoint(function(direction) {
			jQuery('.do-counter').countTo({
				speed: 3500
			});
			this.destroy()
		}, {
			offset: '25%'
		});

	}
}).trigger("resize.showContent")
});

var $blogMasonryContainer = jQuery('.do-masonry-blog-wrapper');

$blogMasonryContainer.imagesLoaded(function(){
	$blogMasonryContainer.isotope({
		itemSelector : '.do-blog-masonry-items',
		masonry: {
			columnWidth: '.do-masonry-blog-wrapper .do-blog-masonry-items'
		}
	});
});


var $portfolioContainer	= jQuery('.do-portfolio-works');

		// filter items on button click
		$portfolioContainer.imagesLoaded(function(){
			$portfolioContainer.isotope({
				filter: '*',
				itemSelector: '.do-work-item',
				animationOptions: {
					duration: 750,
					easing: 'linear',
					queue: false
				},
				masonry: {
				  // use outer width of grid-sizer for columnWidth
				  columnWidth: '.do-work-item'
				}
			});
		});


		jQuery('#do-portfolio-filter a').on('click',function(){
			var selector = jQuery(this).attr('data-filter');
			$portfolioContainer.isotope({
				filter: selector,
				animationOptions: {
					duration: 750,
					easing: 'linear',
					queue: false
				}
			});
			return false;
		});


		var $optionSets = jQuery('#do-portfolio-filter .do-portfolio-filter-btn-group'),
		$optionLinks = $optionSets.find('a');

		$optionLinks.on('click',function(){
			var $this = jQuery(this);
		        // don't proceed if already selected
		        if ( $this.hasClass('selected') ) {
		        	return false;
		        }
		        var $optionSet = $this.parents('#do-portfolio-filter .do-portfolio-filter-btn-group');
		        $optionSet.find('.selected').removeClass('selected');
		        $this.addClass('selected');
		    });


	});



