<?php
    global $post;
    
    $portfolio_related_portfolio = get_option('portfolio_related_portfolio', '8');

    $portfolio = ebor_get_custom_posts("portfolio", $portfolio_related_portfolio);    
?>

<div class="do-portolio-related-work">

    <h3 class="do-section-subtitle">
        <?php echo get_option('portfolio_related_text', 'Related Work');?>
    </h3>

    <div id="do-related-work-carousal" class="owl-carousel do-related-work-carousal">

        <?php
            foreach ($portfolio as $post) {
                setup_postdata($post);   
                $url = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID), 'large');

                if(!( $url[0] ))
                    $url[0] = false;

                ?>

                <div class="do-work-item">
                    <div class="do-work-item-inner-wrap">
                        
                        <?php the_post_thumbnail(); ?>

                        <div class="do-work-item-hover">
                            <a href="<?php echo esc_url($url[0]); ?>" class="do-work-item-popup"></a>
                            <div class="do-work-item-details">
                                <?php the_title('<h3 class="do-work-item-title"><a href="'. get_permalink() .'">', '</a></h3>'); ?>
                                <span class="do-work-item-subtitle"><?php echo ebor_the_terms('portfolio_category', ', ', 'name'); ?></span>
                            </div>
                        </div>
                    </div>
                </div>
        <?php } ?>
        
    </div>

</div>