<?php $logo = get_option('custom_logo_sidebar', EBOR_THEME_DIRECTORY . 'style/images/side-menu-logo.png'); ?>

<div class="do-side-menu-wrap" style="background-image: url(<?php echo get_option('side_menu_background', EBOR_THEME_DIRECTORY . 'style/images/menu-bg.jpg'); ?>);">

    <div class="do-dark-overlay"></div>

    <nav class="do-side-menu">
        <div class="do-side-menu-widget-wrap">

            <div class="do-side-menu-logo-wrap">
                <a href="<?php echo esc_url(home_url('/')); ?>">
                    <img src="<?php echo esc_url($logo); ?>" alt="<?php echo esc_attr(get_bloginfo('title')); ?>" />
                </a>
            </div>

            <div class="do-side-menu-menu-wrap">
            	<?php
            		if ( has_nav_menu( 'side' ) ){
            			wp_nav_menu( 
            				array(
            				    'theme_location'    => 'side',
            				    'depth'             => 1,
            				    'container'         => false,
            				    'menu_class'        => false,
            				    'menu_id'           => false
            				)
            			);
            		}
            	?>
            </div>

            <div class="do-side-menu-social-icon">
                <ul>
                    <?php
                    	$protocols = array('http', 'https', 'ftp', 'ftps', 'mailto', 'news', 'irc', 'gopher', 'nntp', 'feed', 'telnet', 'skype');
                    	
                    	for( $i = 1; $i < 7; $i++ ){
                    		if( get_option("header_social_url_$i") ) {
                    			echo '<li>
                    				      <a href="' . esc_url(get_option("header_social_url_$i"), $protocols) . '" target="_blank">
                    					      <i class="' . get_option("header_social_icon_$i") . '"></i>
                    				      </a>
                    				  </li>';
                    		}
                    	} 
                    ?>
                </ul>
            </div>

        </div>
    </nav>

    <button class="do-side-menu-close-button" id="do-side-menu-close-button"><?php esc_html_e('Close Menu','do'); ?></button>
    
</div>