<?php 
/**
 * Returns 1st Header 
 * 
 * @since v1.0.0
 * @package Do
 * @author Jewel Theme
 */

$logo = get_option('custom_logo', EBOR_THEME_DIRECTORY . 'style/images/logo.png');
$header_side_nav = get_option('header_side_nav', 'yes');
?>
	
<header>
    <nav class="navbar do-main-menu">
        <div class="container">

            <div class="navbar-header">
            
                <button type="button" class="navbar-toggle" data-toggle="collapse" data-target=".navbar-collapse">
                    <span class="icon-bar"></span>
                    <span class="icon-bar"></span>
                    <span class="icon-bar"></span>
                </button>

                <?php if( $header_side_nav == "yes" ){ ?>
                    <button class="do-side-menu-button" id="do-side-menu-open-button"></button>
                <?php } ?>                

                <a class="navbar-brand" href="<?php echo esc_url(home_url('/')); ?>">
                	<img class="logo" alt="<?php echo esc_attr(get_bloginfo('title')); ?>" src="<?php echo esc_url($logo); ?>" />
                </a>

            </div>

            <div id="nav-menu" class="navbar-collapse do-menu-wrapper collapse">
            	<?php
            		if ( has_nav_menu( 'primary' ) ){
            			wp_nav_menu( 
            				array(
            				    'theme_location'    => 'primary',
            				    'depth'             => 3,
            				    'container'         => false,
            				    'menu_class'        => 'nav navbar-nav do-menus',
            				    'menu_id'           => false
            				)
            			);
            		} else {
            			echo '<ul class="nav navbar-nav do-menus"><li>Set a menu up in "appearance" => "menus"</li></ul>';
            		}
            	?>
            </div>

        </div>
    </nav>
</header>