<?php 

/**
 * Build theme metaboxes
 * Uses the cmb metaboxes class found in the ebor framework plugin
 * More details here: https://github.com/WebDevStudios/Custom-Metaboxes-and-Fields-for-WordPress
 * 
 * @since 1.0.0
 * @author tommusrhodus
 */
if(!( function_exists('ebor_custom_metaboxes') )){
	function ebor_custom_metaboxes( $meta_boxes ) {
		
		/**
		 * Setup variables
		 */
		$prefix = '_ebor_';
		$header_options = ebor_get_header_options();
		
		$header_overrides['none'] = 'Do Not Override Header Option On This Page';
		foreach( $header_options as $key => $value ){
			$header_overrides[$key] = 'Override Header: ' . $value; 	
		}

		
		$social_options = ebor_get_icons();
		foreach( $social_options as $social ){
			$new_social_options[$social] = ucfirst(str_replace('ti-', '', $social));	
		}
		
		/**
		 * Social Icons for Team Members
		 */
		$meta_boxes[] = array(
			'id' => 'team_social_metabox',
			'title' => esc_html__('Team Member Details', 'do'),
			'object_types' => array('team'), // post type
			'context' => 'normal',
			'priority' => 'high',
			'show_names' => true, // Show field names on the left
			'fields' => array(
				array(
					'name' => esc_html__('Job Title', 'do'),
					'desc' => '(Optional) Enter a Job Title for this Team Member',
					'id'   => $prefix . 'the_job_title',
					'type' => 'text',
				),
				array(
				    'id'          => $prefix . 'team_social_icons',
				    'type'        => 'group',
				    'options'     => array(
				        'add_button'    => esc_html__( 'Add Another Icon', 'do' ),
				        'remove_button' => esc_html__( 'Remove Icon', 'do' ),
				        'sortable'      => true
				    ),
				    'fields' => array(
						array(
							'name' => 'Social Icon',
							'desc' => 'What icon would you like for this team members first social profile?',
							'id' => $prefix . 'social_icon',
							'type' => 'select',
							'options' => $new_social_options
						),
						array(
							'name' => esc_html__('URL for Social Icon', 'do'),
							'desc' => esc_html__("Enter the URL for Social Icon 1 e.g www.google.com", 'do'),
							'id'   => $prefix . 'social_icon_url',
							'type' => 'text_url',
						),
				    ),
				),
			)
		);			

		/**
		 * Portfolio Style like Double Height/Width
		 */
		$meta_boxes[] = array(
			'id' => 'portfolio_style_metabox',
			'title' => esc_html__('Portfolio Style', 'do'),
			'object_types' => array('portfolio'), // post type
			'context' => 'normal',
			'priority' => 'high',
			'show_names' => true, // Show field names on the left
			'fields' => array(
				array(
					'name' => esc_html__('Portfolio Style', 'do'),
					'desc' => 'Select Portfolio Style. Example: Double Height, Double Width or Normal',
					'id'   => $prefix . 'portfolio_style',
					'type' => 'select',
					'options' => array(
						'' 				=> 'Default',
						'do-height-dbl' => 'Double Height',
						'do-width-dbl' 	=> 'Double Width'
					)
				),

			)
		);


		/**
		 * Page Header Changes
		 * Uses the cmb metaboxes class found in the ebor framework plugin
		 * More details here: https://github.com/WebDevStudios/Custom-Metaboxes-and-Fields-for-WordPress
		 * 
		 * @since 1.0.0
		 * @author Jewel Theme
		 */
		$meta_boxes[] = array(
			'id' => 'page_header_metabox',
			'title' => __('Page Overrides', 'do'),
			'object_types' => array('page'), // post type
			'context' => 'normal',
			'priority' => 'low',
			'show_names' => true, // Show field names on the left
			'fields' => array(
				array(
					'name'         => __( 'Override Header?', 'do' ),
					'desc'         => __( 'Header Layout is set in "appearance" -> "customise". To override this for this page only, use this control.', 'do' ),
					'id'           => $prefix . 'header_override',
					'type'         => 'select',
					'options'      => $header_overrides,
					// 'std'          => 'none'
				),

			)
		);


		
		return $meta_boxes;
	}
	add_filter( 'cmb2_meta_boxes', 'ebor_custom_metaboxes' );
}

