<?php 

/**
 * Register Menu Locations For The Theme
 * 
 * @since 1.0.0
 * @author tommusrhodus
 */
if(!( function_exists('ebor_register_nav_menus') )){
	function ebor_register_nav_menus() {
		register_nav_menus( 
			array(
				'primary'  => esc_html__( 'Standard Navigation', 'do' ),
				'side'  => esc_html__( 'Offscreen Navigation', 'do' )
			) 
		);
	}
	add_action( 'init', 'ebor_register_nav_menus' );
}

if(!( function_exists('ebor_register_sidebars') )){
	function ebor_register_sidebars() {
	
		register_sidebar( 
			array(
				'id' => 'primary',
				'name' => esc_html__( 'Blog Sidebar', 'do' ),
				'description' => esc_html__( 'Widgets to be displayed in the blog sidebar.', 'do' ),
				'before_widget' => '<div id="%1$s" class="do-blog-sidebar-widget widget %2$s">',
				'after_widget' => '</div>',
				'before_title' => '<h3 class="do-sidebar-widget-title">',
				'after_title' => '</h3>'
			) 
		);
		
		register_sidebar( 
			array(
				'id' => 'portfolio',
				'name' => esc_html__( 'Portfolio Sidebar', 'do' ),
				'description' => esc_html__( 'Widgets to be displayed in the portfolio post sidebar.', 'do' ),
				'before_widget' => '<div id="%1$s" class="do-blog-sidebar-widget widget %2$s">',
				'after_widget' => '</div>',
				'before_title' => '<h3 class="do-sidebar-widget-title">',
				'after_title' => '</h3>'
			) 
		);
		
		register_sidebar(
			array(
				'id' => 'footer1',
				'name' => esc_html__( 'Footer Column 1', 'do' ),
				'description' => esc_html__( 'If this is set, your footer will be 1 column', 'do' ),
				'before_widget' => '<div id="%1$s" class="do-footer-widget widget %2$s">',
				'after_widget' => '</div>',
				'before_title' => '<h3 class="do-footer-widget-header">',
				'after_title' => '</h3>'
			)
		);
		
		register_sidebar(
			array(
				'id' => 'footer2',
				'name' => esc_html__( 'Footer Column 2', 'do' ),
				'description' => esc_html__( 'If this & column 1 are set, your footer will be 2 columns.', 'do' ),
				'before_widget' => '<div id="%1$s" class="do-footer-widget widget %2$s">',
				'after_widget' => '</div>',
				'before_title' => '<h3 class="do-footer-widget-header">',
				'after_title' => '</h3>'
			)
		);
		
		
		register_sidebar(
			array(
				'id' => 'footer3',
				'name' => esc_html__( 'Footer Column 3', 'do' ),
				'description' => esc_html__( 'If this & column 1 & column 2 are set, your footer will be 3 columns.', 'do' ),
				'before_widget' => '<div id="%1$s" class="do-footer-widget widget %2$s">',
				'after_widget' => '</div>',
				'before_title' => '<h3 class="do-footer-widget-header">',
				'after_title' => '</h3>'
			)
		);
		
		register_sidebar(
			array(
				'id' => 'footer4',
				'name' => esc_html__( 'Footer Column 4', 'do' ),
				'description' => esc_html__( 'If this & column 1 & column 2 & column 3 are set, your footer will be 4 columns.', 'do' ),
				'before_widget' => '<div id="%1$s" class="do-footer-widget widget %2$s">',
				'after_widget' => '</div>',
				'before_title' => '<h3 class="do-footer-widget-header">',
				'after_title' => '</h3>'
			)
		);
		
	}
	add_action( 'widgets_init', 'ebor_register_sidebars' );
}