<?php 

/**
 * The Shortcode
 */
function ebor_skill_bar_block_shortcode( $atts, $content = null ) {
	extract( 
		shortcode_atts( 
			array(
				'title' => '',
				'amount' => ''
			), $atts 
		) 
	);
	
	$output = '
		<div class="do-skillbar clearfix" data-percent="'. (int) $amount .'">
		    <p class="do-skillbar-title">'. trim(strip_tags($title)) .'<span class="skill-bar-percent"></span></p>
		    <div class="do-skillbar-bar-wrapper">
		        <div class="do-skillbar-bar"></div>
		    </div>
		</div> 
	';

	return $output;
}
add_shortcode( 'do_skill_bar_block', 'ebor_skill_bar_block_shortcode' );

/**
 * The VC Functions
 */
function ebor_skill_bar_block_shortcode_vc() {
	vc_map( 
		array(
			"icon" => 'do-vc-block',
			"name" => __("Skill Bar", 'do'),
			"base" => "do_skill_bar_block",
			"category" => __('do WP Theme', 'do'),
			'description' => 'Coloured bars for demonstrating your skills.',
			"params" => array(
				array(
					"type" => "textfield",
					"heading" => __("Skill Title", 'do'),
					"param_name" => "title",
					'holder' => 'div'
				),
				array(
					"type" => "textfield",
					"heading" => __("Skill Amount", 'do'),
					"param_name" => "amount",
					'description' => 'Use a value between 0 - 100 only.'
				),
			)
		) 
	);
}
add_action( 'vc_before_init', 'ebor_skill_bar_block_shortcode_vc' );