<?php 

/**
 * The Shortcode
 */
function ebor_portfolio_shortcode( $atts ) {
	extract( 
		shortcode_atts( 
			array(
				'type' => '2col',
				'pppage' => '999',
				'filter' => 'all',
				'filters' => 'yes',
				'more' => 'no'
			), $atts 
		)
	);
	
	// Fix for pagination
	if( is_front_page() ) { 
		$paged = ( get_query_var( 'page' ) ) ? get_query_var( 'page' ) : 1; 
	} else { 
		$paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1; 
	}
	
	/**
	 * Initial query args
	 */
	$query_args = array(
		'post_type' => 'portfolio',
		'posts_per_page' => $pppage,
		'paged' => $paged
	);
	
	if (!( $filter == 'all' )) {
		if( function_exists( 'icl_object_id' ) ){
			$filter = (int)icl_object_id( $filter, 'portfolio_category', true);
		}
		$query_args['tax_query'] = array(
			array(
				'taxonomy' => 'portfolio_category',
				'field' => 'id',
				'terms' => $filter
			)
		);
	}

	$block_query = new WP_Query( $query_args );
	
	if( $filter == 'all' ){
		$cats = get_categories('taxonomy=portfolio_category');
	} else {
		$cats = get_categories('taxonomy=portfolio_category&exclude='. $filter .'&child_of='. $filter);
	}
	
	if( '2col' == $type ){
		$class = 'do-work-item-2col';	
	} elseif( '3col' == $type ){
		$class = 'do-work-item-3col';	
	} elseif( '4col' == $type ){
		$class = 'do-work-item-4col';	
	} elseif( '5col' == $type ){
		$class = 'do-portfolio-one-px';	
	} elseif( '4col-gap' == $type ){
		$class = 'do-work-item-withspace';	
	}
	
	ob_start();
	
	if( 'slider' == $type ) :
?>
	
	<div class="row">
		<div id="do-portfolio-slider" class="owl-carousel do-portfolio-slider">
			<?php 
				if ( $block_query->have_posts() ) : while ( $block_query->have_posts() ) : $block_query->the_post();
				
					/**
					* Get blog posts by blog layout.
					*/
					get_template_part('loop/content-portfolio', 'slider');
				
				endwhile;	
				else : 
				
					/**
					* Display no posts message if none are found.
					*/
					get_template_part('loop/content','none');
				
				endif;
			?>
		</div>
	</div>
	
	<?php else :  ?>
	
	<div class="row">
		<div class="do-portfolio-works-wrapper">
			
			<?php if( 'yes' == $filters && !( is_tax() ) ) : ?>
				<div id="do-portfolio-filter" class="do-portfolio-filter-btn-group-wrapper">
				    <div class="do-portfolio-filter-btn-group">
				        <a href="#" class="selected" data-filter="*"><?php _e('All','do'); ?></a>
				        <?php
				        	$cats = get_categories('taxonomy=portfolio_category');
				        	if(is_array($cats)){
				        		foreach($cats as $cat){
				        			echo '<a href="#" data-filter=".'. esc_attr($cat->slug) .'">'. $cat->name .'</a>';
				        		}
				        	}
				        ?>
				    </div>
				</div>
			<?php endif; ?>
			
			<div class="do-portfolio-works <?php echo esc_attr($class); ?>">
				<?php 
					if ( $block_query->have_posts() ) : while ( $block_query->have_posts() ) : $block_query->the_post();
					
						/**
						* Get blog posts by blog layout.
						*/
						get_template_part('loop/content-portfolio', 'masonry');
					
					endwhile;	
					else : 
					
						/**
						* Display no posts message if none are found.
						*/
						get_template_part('loop/content','none');
					
					endif;
				?>
			</div>
		
		</div>
	</div>
			
<?php	
	endif;
	
	wp_reset_postdata();
	
	$output = ob_get_contents();
	ob_end_clean();
	
	return $output;
}
add_shortcode( 'do_portfolio', 'ebor_portfolio_shortcode' );

/**
 * The VC Functions
 */
function ebor_portfolio_shortcode_vc() {
	
	$portfolio_types = ebor_get_portfolio_layouts();

	vc_map( 
		array(
			"icon" => 'do-vc-block',
			"name" => __("Portfolio Feeds", 'do'),
			"base" => "do_portfolio",
			"category" => __('do WP Theme', 'do'),
			'description' => 'Show portfolio posts in the page.',
			"params" => array(
				array(
					"type" => "textfield",
					"heading" => __("Show How Many Posts?", 'do'),
					"param_name" => "pppage",
					"value" => '8'
				),
				array(
					"type" => "dropdown",
					"heading" => __("Display type", 'do'),
					"param_name" => "type",
					"value" => $portfolio_types
				),
				array(
					"type" => "dropdown",
					"heading" => __("Show Filters?", 'do'),
					"param_name" => "filters",
					"value" => array(
						'Yes' => 'yes',
						'No' => 'no'
					),
				),
			)
		) 
	);
	
}
add_action( 'vc_before_init', 'ebor_portfolio_shortcode_vc');