<?php 

/**
 * The Shortcode
 */

function ebor_left_icon_block_shortcode( $atts, $feature_left_box_content = null ) {
	extract( 
		shortcode_atts( 
			array(
				'feature_left_box_icon' 		=> 'ti-mobile',
				'feature_left_box_title' 		=> 'RESPONSIVE',
				'feature_left_box_content' 		=> 'On the other hand, we denounce with right ous indignation and dislike mens who are so beguiled'
			), $atts 
		) 
	);
	
		$output = '
		<div class="do-icon-with-text-style-2 do-icon-left appear fadeIn" data-wow-duration="1s" data-wow-delay="'. esc_attr($feature_left_box_title) .'">
			<div class="do-icon-wrapper">
				<i class="'. esc_attr($feature_left_box_icon) .'"></i>
			</div>
			
			<div class="do-text-wrapper">
				<h3><a href="#">'. esc_attr($feature_left_box_title) .'</a></h3>
				'. wpautop(do_shortcode(htmlspecialchars_decode($feature_left_box_content))) .'
			</div>
		</div>';

	return $output;

}

add_shortcode( 'do_left_icon_box', 'ebor_left_icon_block_shortcode' );


/**
 * The VC Functions
 */
function ebor_left_icon_block_shortcode_vc() {
	
	$icons = ebor_get_icons();

	$types = array(
		'Colours' => 'do-icon-with-text-style-2',
		'Colour on Hover' => 'do-icon-with-text-style3'
		);
	
	
	vc_map( 
		array(
			"icon" => 'do-vc-block',
			"name" => __("Left Icon Box", 'do'),
			"base" => "do_left_icon_box",
			"category" => __('do WP Theme', 'do'),
			'description' => 'Show client posts with layout options.',
			"params" => array(

			    array(
			    	"type" => "ebor_icons",
			    	'heading'      => esc_html__( 'Icon', 'do' ),
			    	"param_name" => "feature_left_box_icon",
			    	"value" => $icons,
			    	'description' => 'Type "none" or leave blank to hide icons.'
			    	),
			    array(
			    	"type" => "textfield",
			    	"heading" => __("Title", 'do'),
			    	"param_name" => "feature_left_box_title",
			    	'value' => 'RESPONSIVE',
			    	),
			    array(
			    	"type" => "textarea_html",
			    	"heading" => __("Block Content", 'do'),
			    	"param_name" => "feature_left_box_content",
			    	'holder' => 'p',
			    	"value" => esc_html__('On the other hand, we denounce with right ous indignation and dislike mens who are so beguiled', "do")
			    	),

			)
		)

	);
	}
	
add_action( 'vc_before_init', 'ebor_left_icon_block_shortcode_vc');


