<?php

/**
 * The template for displaying Course font
 *
 * Override this template by copying it to yourtheme/course/single/front.php
 *
 * @author 		VibeThemes
 * @package 	vibe-course-module/templates
 * @version     1.8.1
 */


global $post;
$id= get_the_ID();

do_action('wplms_course_before_front_main');

if(have_posts()):
while(have_posts()):the_post();
?>

<?php
do_action('wplms_before_course_description');
?>
<div class="course_description" itemprop="description">
	<div class="small_desc">
	<?php 
		$more_flag = 1;
		$content=get_the_content(); 
		$middle=strpos( $post->post_content, '<!--more-->' );
		if($middle){
			echo apply_filters('the_content',substr($content, 0, $middle));
		}else{
			$limit=apply_filters('wplms_course_excerpt_limit',1200);
			$middle = strrpos(substr($content, 0, $limit), " ");

			if(strlen($content) < $limit){
				$more_flag = 0;
			}
			$check_vc=strpos( $post->post_content, '[vc_row]' );
			if ( isset($check_vc) ) {
				$more_flag=0;
				echo apply_filters('the_content',$content);
			}else{
				echo apply_filters('the_content',substr($content, 0, $middle));
			}
		}
	?>
	<?php 
		if($more_flag)
			echo '<a href="#" id="more_desc" class="link" data-middle="'.$middle.'">'.__('READ MORE','vibe').'</a>';
	?>
	</div>
	<?php if($more_flag){ ?>
	<div class="full_desc">
	<?php 
		echo apply_filters('the_content',substr($content, $middle,-1));
	?>
	<?php 
		echo '<a href="#" id="less_desc" class="link">'.__('LESS','vibe').'</a>';
	?>
	</div>
	<?php
		}
	?>
</div>
<?php
do_action('wplms_after_course_description');
?>

<div class="course_reviews">
<ol class="reviewlist commentlist"> 
	  <?php 
	        wp_list_comments('type=comment&avatar_size=120&reverse_top_level=false'); 
	        paginate_comments_links( array('prev_text' => '&laquo;', 'next_text' => '&raquo;') )
	    ?>  
	  </ol> 
	  
<?php
	 comments_template('/course-review.php',true);
?>
</div>
<div class="related_courses">
<h2><?php _e('Related Courses','vibe');?></h2>
<?php
	$terms = wp_get_post_terms(get_the_ID(),'course-cat');
	$categories = array();
	if(!empty($terms)){
		foreach($terms as $term)
		$categories[] = $term->term_id;
	}
	$args = apply_filters('wplms_moern_related_courses',array(
		'post_type' => 'course',
		'posts_per_page'=>3,
		'tax_query' => array(
				'relation' => 'OR',
				array(
					'taxonomy' => 'course-cat',
					'field'    => 'id',
					'terms'    => $categories,
				),
		),
		));
	$args = apply_filters('wplms_carousel_course_filters',$args);
	$courses = new WP_Query($args);
	
	if($courses->have_posts()):
	?>
	<ul class="row">
	<?php	
	while($courses->have_posts()): $courses->the_post();
	echo '<li class="col-md-4">';
	$style = vibe_get_option('related_course_style');
	if(empty($style))
		$style = 'modern1';
	echo thumbnail_generator($post,$style,'medium');
	echo '</li>';
	endwhile;
	?>
	</ul>
	<?php
	endif;
	wp_reset_postdata();
?>
</div>
<?php
endwhile;
endif;
?>